<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class DPII_Session extends CI_Session {
   /*
    * Do not update an existing session on ajax calls
    *
    * @access    public
    * @return    void
    */
    public function sess_update()
    {
        if ( ! IS_AJAX)
        {
            parent::sess_update();
        }
    }

    function sess_destroy()
    {
        parent::sess_destroy();

        $this->userdata = array();
    }

	//sets an error message in the flashdata	
	public function set_error_message($message){
		$this->set_flashdata('message',$message);
		$this->set_flashdata('message_class','error');
	}
	
	public function set_service_permission_error_message($service, $message){
		$this->session->set_flashdata('service_failure_due_to_permission',true);
		$this->session->set_flashdata('failed_service_name', $service);
		$this->session->set_flashdata('service_failure_due_to_permission_message',$message);       
	}
	
	public function set_success_message($message){
		$this->set_flashdata('message', $message);
		$this->set_flashdata('message_class','success');	
	}
} 